#!/bin/bash

echo "=========================================="
echo "Display Switcher - ПОЛНАЯ ПЕРЕСБОРКА"
echo "=========================================="
echo ""

# Удаляем старую сборку
if [ -d "build" ]; then
    echo "Удаление старой сборки..."
    rm -rf build
fi

# Создаём новую директорию
mkdir build
cd build

# Запускаем CMake
echo "Запуск CMake..."
cmake ..

if [ $? -ne 0 ]; then
    echo "Ошибка CMake!"
    exit 1
fi

# Компилируем
echo "Компиляция..."
make clean
make

if [ $? -ne 0 ]; then
    echo "Ошибка компиляции!"
    exit 1
fi

echo ""
echo "=========================================="
echo "✓ Пересборка завершена успешно!"
echo "=========================================="
echo ""
echo "Файл: ./build/display-switcher"
echo ""
echo "ВАЖНО: Перед запуском отключите GNOME Win+P:"
echo "  ./disable-gnome-winp.sh"
echo ""
echo "Запуск:"
echo "  cd build"
echo "  ./display-switcher"
echo "=========================================="
