#include <QApplication>
#include <QSystemTrayIcon>
#include <QMenu>
#include <QIcon>
#include <QStyle>
#include "displayswitcher.h"
#include "hotkeymanager.h"

int main(int argc, char *argv[])
{
    QApplication app(argc, argv);
    app.setQuitOnLastWindowClosed(false);

    DisplaySwitcher switcher;
    HotkeyManager hotkeyManager;

    // Связываем сигнал горячей клавиши с показом окна
    QObject::connect(&hotkeyManager, &HotkeyManager::hotkeyPressed,
                     &switcher, &DisplaySwitcher::showSwitcher);

    // Регистрируем горячие клавиши
    if (!hotkeyManager.registerHotkey()) {
        qWarning() << "Failed to register hotkeys";
        return 1;
    }

    // Создаём иконку в системном трее
    QSystemTrayIcon trayIcon;
    QIcon icon = app.style()->standardIcon(QStyle::SP_ComputerIcon);
    trayIcon.setIcon(icon);
    trayIcon.setToolTip("Display Switcher (Win+P или Ctrl+P)");

    // Создаём меню для трея
    QMenu trayMenu;
    QAction *showAction = trayMenu.addAction("Показать переключатель");
    QAction *quitAction = trayMenu.addAction("Выход");

    QObject::connect(showAction, &QAction::triggered, &switcher, &DisplaySwitcher::showSwitcher);
    QObject::connect(quitAction, &QAction::triggered, &app, &QApplication::quit);

    trayIcon.setContextMenu(&trayMenu);
    trayIcon.show();

    qDebug() << "Display Switcher запущен. Используйте Win+P или Ctrl+P для переключения дисплеев.";

    return app.exec();
}
