#ifndef HOTKEYMANAGER_H
#define HOTKEYMANAGER_H

#include <QObject>
#include <QThread>

// Forward declarations для X11 типов
typedef struct _XDisplay Display;
typedef unsigned long Window;

class HotkeyManager : public QThread
{
    Q_OBJECT

public:
    explicit HotkeyManager(QObject *parent = nullptr);
    ~HotkeyManager();

    bool registerHotkey();
    void unregisterHotkey();

signals:
    void hotkeyPressed();

protected:
    void run() override;

private:
    Display *display;
    Window root;
    bool running;
    int keycode_p;
    int keycode_ctrl;
    int keycode_super;
};

#endif // HOTKEYMANAGER_H
