#!/bin/bash

echo "Display Switcher - сборка проекта"
echo "=================================="

# Проверка зависимостей
echo "Проверка зависимостей..."
if ! dpkg -l | grep -q qt6-base-dev; then
    echo "Устанавливаем зависимости..."
    sudo apt install -y qt6-base-dev qt6-tools-dev cmake build-essential libx11-dev libxtst-dev
fi

# Создание директории сборки
if [ -d "build" ]; then
    echo "Очистка старой сборки..."
    rm -rf build
fi

mkdir build
cd build

# Сборка
echo "Запуск CMake..."
cmake ..

if [ $? -ne 0 ]; then
    echo "Ошибка CMake!"
    exit 1
fi

echo "Компиляция..."
make

if [ $? -ne 0 ]; then
    echo "Ошибка компиляции!"
    exit 1
fi

echo ""
echo "=================================="
echo "Сборка завершена успешно!"
echo "Запустите программу: ./build/display-switcher"
echo "=================================="
