# Display Switcher для Ubuntu 24.04

Аналог Windows Win+P меню для переключения режимов экранов в Ubuntu.

**Дизайн**: бордовая цветовая схема в стиле [madmentat.ru](https://madmentat.ru)

## Возможности

- **Win+P** или **Ctrl+P** - вызов меню переключения
- Режимы:
  - Только экран компьютера
  - Повторяющийся (дублирование)
  - Расширить
  - Только второй экран
- Навигация клавишами: стрелки вверх/вниз, Tab, Enter, Escape
- Иконка в системном трее
- Стильный бордовый интерфейс
- Ссылка на сайт разработчика

## Установка зависимостей

```bash
sudo apt install qt6-base-dev qt6-tools-dev cmake build-essential libx11-dev libxtst-dev
```

## Сборка

```bash
cd display-switcher
./build.sh
```

## Быстрая установка

После сборки:

```bash
cd build
./install.sh
```

Скрипт автоматически:
- Установит программу в систему
- Отключит нативное GNOME Win+P
- Настроит автозапуск
- Создаст ярлык в меню
- Предложит настроить терминал в тех же цветах

## Ручная установка

```bash
cd build
sudo cp display-switcher /usr/local/bin/
/usr/local/bin/display-switcher &
```

## Настройка терминала

Для настройки GNOME Terminal в бордовых тонах:

```bash
./setup-terminal.sh
```

## Отключение нативного GNOME Win+P

```bash
gsettings set org.gnome.mutter.keybindings switch-monitor "[]"
```

## Горячие клавиши

- **Win+P** - показать меню (как в Windows)
- **Ctrl+P** - показать меню (альтернативный вариант)
- **Стрелки вверх/вниз** - навигация по пунктам меню
- **Tab** - следующий пункт
- **Enter** - выбрать
- **Escape** - закрыть меню

## Примечания

- Программа использует `xrandr` для управления мониторами
- Автоматически определяет подключенные дисплеи
- Работает в X11 (для Wayland потребуется доработка)

## Удаление

```bash
sudo rm /usr/local/bin/display-switcher
rm ~/.config/autostart/display-switcher.desktop
```
